
#include <standard.h>
#include "memory.h"
#include "lang.h"
#include "shell.rsrc.h"
#include "shellundo.h"
#include "tableinternal.h"
#include "tablestructure.h"



boolean tablemakenewvalue (void) {
	
	/*
	create a new, empty value below the current cell.
	
	to get the node to be inserted below the current position, we use
	tableoverridesort to patch the comparenodes langglobals callback and 
	look for the next node in the table
	*/
	
	register hdlhashtable ht;
	bigstring bsname;
	tyvaluerecord val;
	short newrow;
	hdlhashnode hnode, hnext;
	register boolean fl;
	
	pushundoaction (undotypingstring);
	
	if (tableempty ())
		newrow = 0;
	else
		newrow = (**tableformatsdata).rowcursor + 1;
	
	ht = tablegetlinkedhashtable ();
	
	pushhashtable (ht);
	
	hashgetnthnode (ht, newrow, &hnext); /*ignore result -- will be nil if rowcursor is last*/
	
	tableoverridesort (hnext);
	
	setemptystring (bsname);
	
	clearbytes (&val, longsizeof (val));
	
	fl = hashinsert (bsname, val);
	
	assert (tablevalidate (ht, true));
	
	tablerestoresort ();
	
	// (**ht).flneedsort = true;
	
	pophashtable ();
	
	if (!fl)
		return (false);
	
	if (hashgetnthnode (ht, newrow, &hnode))
		pushundostep ((undocallback) tableredoclear, (Handle) hnode);
	
	if (!tableeditentercell (newrow, namecolumn)) {
		
		undolastaction (false);
		
		return (false);
		}
	
	return (true);
	} /*tablemakenewvalue*/



